//---------------------------------------------------------------------------------------------
//  
//  Программа поддержки в ПЛИС  GoWin следущих IP-ядер:
//     IP-ядра  MCU Cortex-M1, 
//     IP-ядра UART,  
//     IP-ядра GPIO.       
//
//  Программа реализует:
//     управление выходами подключения светодиодов,  
//     опрос входа  подключения кнопки, 
//     обмен через UART. 
//
//
//  Внешний синхросигнал  XTAL = 54 МГц   (файл system_GOWIN_M1.c). 
//  Чатота синхронизации IP-ядра  MCU            SYSTEM_CLOCK  =  XTAL. 
//
//-------------------------------------------------------------------------------------------- 



/* Includes ------------------------------------------------------------------*/
#include "GOWIN_M1.h"
#include <stdio.h>

#define  DELAY_1   500000   //  задержка 

#define  Baud_Rate_UART   115200  //  скорость обмена через UART  

#define  Simvol_UART_OK  'A'  // символ, ожидаемый на приеме UART 

#define  Simv_CR   13  // Символ перевода строки  при обмене через UART 

// константы нажатия/ненажатия кнопки, активный уровень кнопки - низкий
#define KEY_ON	0
#define KEY_OFF	1

// Сброс, установка и тестирование битов   
#define  BIT_SET(address,bit)     (address |= (1 << bit))
#define  BIT_CLEAR(address,bit)   (address &= ~(1 << bit))
#define  BIT_TEST(address,bit)    (address & (1 << bit))



/* Declarations ------------------------------------------------------------------*/
void GPIOInit(void);
void UartInit(void);

void  UART_Zastavka_UART (void);  
void  UART_Button_ON (void);
void  UART_Button_OFF (void);
void  UART_Send_OK (void);
void  UART_Send_ERR (void); 

uint8_t GPIO_ReadInputDataBit(GPIO_TypeDef* GPIOx, uint16_t GPIO_Pin);

void delay(__IO uint32_t nCount);

char DATA_UART_RX = 0;  // принятый через UART символ 



//---------------------------------------------------------------------------------------
int main(void)
{
	SystemInit();//Initializes system clock
	
	GPIOInit();//Initializes GPIO0
	
	UartInit();					//Initializes uart0

	delay(DELAY_1);
	
	UART_Zastavka_UART ();
	
	
//---------------------------------------------------------------------------------------	
  while(1)
  {
		     
		// опрашиваем подключенную на входе GPIO кнопку 
		if (GPIO_ReadInputDataBit(GPIO0, GPIO_Pin_6) == KEY_OFF) 
		  {
			  //  Кнопка  не нажата -  LED  загораются  в цикле  
				GPIO_SetBit(GPIO0,GPIO_Pin_7);  // задание 1 текущей индикаци  на ЖКИ  в проекте ПЛИС
				
				
				GPIO_SetBit(GPIO0,GPIO_Pin_0);
				GPIO_SetBit(GPIO0,GPIO_Pin_1);
				GPIO_SetBit(GPIO0,GPIO_Pin_2);
				GPIO_SetBit(GPIO0,GPIO_Pin_3);
				GPIO_SetBit(GPIO0,GPIO_Pin_4);
				GPIO_ResetBit(GPIO0,GPIO_Pin_5);
				delay(DELAY_1);

		    
				GPIO_SetBit(GPIO0,GPIO_Pin_0);
				GPIO_SetBit(GPIO0,GPIO_Pin_1);
				GPIO_SetBit(GPIO0,GPIO_Pin_2);
				GPIO_SetBit(GPIO0,GPIO_Pin_3);
				GPIO_ResetBit(GPIO0,GPIO_Pin_4);
				GPIO_SetBit(GPIO0,GPIO_Pin_5);		    
				delay(DELAY_1);
    
				GPIO_SetBit(GPIO0,GPIO_Pin_0);
				GPIO_SetBit(GPIO0,GPIO_Pin_1);
				GPIO_SetBit(GPIO0,GPIO_Pin_2);
				GPIO_ResetBit(GPIO0,GPIO_Pin_3);
				GPIO_SetBit(GPIO0,GPIO_Pin_4);
				GPIO_SetBit(GPIO0,GPIO_Pin_5);
        delay(DELAY_1);

				GPIO_SetBit(GPIO0,GPIO_Pin_0);
				GPIO_SetBit(GPIO0,GPIO_Pin_1);
				GPIO_ResetBit(GPIO0,GPIO_Pin_2);
				GPIO_SetBit(GPIO0,GPIO_Pin_3);
				GPIO_SetBit(GPIO0,GPIO_Pin_4);
				GPIO_SetBit(GPIO0,GPIO_Pin_5);
        delay(DELAY_1);
		
				GPIO_SetBit(GPIO0,GPIO_Pin_0);
				GPIO_ResetBit(GPIO0,GPIO_Pin_1);
				GPIO_SetBit(GPIO0,GPIO_Pin_2);
				GPIO_SetBit(GPIO0,GPIO_Pin_3);
				GPIO_SetBit(GPIO0,GPIO_Pin_4);
				GPIO_SetBit(GPIO0,GPIO_Pin_5);
        delay(DELAY_1);		
		
				GPIO_ResetBit(GPIO0,GPIO_Pin_0);
				GPIO_SetBit(GPIO0,GPIO_Pin_1);
				GPIO_SetBit(GPIO0,GPIO_Pin_2);
				GPIO_SetBit(GPIO0,GPIO_Pin_3);
				GPIO_SetBit(GPIO0,GPIO_Pin_4);
				GPIO_SetBit(GPIO0,GPIO_Pin_5);
        delay(DELAY_1);

        UART_Button_OFF ();
			}	
    
		//  Кнопка   нажата -  LED  загораются все 	
		else 
		  {
				GPIO_ResetBit(GPIO0,GPIO_Pin_7);  // задание 2 текущей индикаци  на ЖКИ  в проекте ПЛИС
				
        GPIO_ResetBit(GPIO0,GPIO_Pin_0);
				GPIO_ResetBit(GPIO0,GPIO_Pin_1);
				GPIO_ResetBit(GPIO0,GPIO_Pin_2);
				GPIO_ResetBit(GPIO0,GPIO_Pin_3);
				GPIO_ResetBit(GPIO0,GPIO_Pin_4);
				GPIO_ResetBit(GPIO0,GPIO_Pin_5);  
        delay(DELAY_1);
				
				UART_Button_ON ();
			} 	
			
			// проверяем, не принят ли какой символ через UART  	
			if  ((UART0->STATE & UART_STATE_RXBF)) 
			  {
					DATA_UART_RX = UART_ReceiveChar(UART0);  // Если принят, сохраняем его 
					 
				 // проверяем, не ожидаемый ли символ  принят  	
			   if (DATA_UART_RX == Simvol_UART_OK)
				  {
              UART_Send_OK ();  // если  ожидаемый,  отвечаем OK 
              GPIO_SetBit(GPIO0,GPIO_Pin_15); // установить выход управления  ПЛИС						
          } 						
				 else 
 				  {
              UART_Send_ERR ();  // если  другой,  отвечаем ERR  
              GPIO_ResetBit(GPIO0,GPIO_Pin_15); // сбросить выход управления  ПЛИС						
          } 						
				}  
			    				 
		 	
			
  }
} 


//Initialize GPIO
void GPIOInit(void)
{
	GPIO_InitTypeDef GPIO_InitType;
	
	// OUT 
	GPIO_InitType.GPIO_Pin = GPIO_Pin_0 |
	                         GPIO_Pin_1 |
	                         GPIO_Pin_2 |
	                         GPIO_Pin_3 |
	                         GPIO_Pin_4 |
	                         GPIO_Pin_5 | 
	                         GPIO_Pin_15;
	GPIO_InitType.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitType.GPIO_Int = GPIO_Int_Disable;

	GPIO_Init(GPIO0,&GPIO_InitType);

	
	
  // погасить все LED 	
  GPIO_SetBit(GPIO0,GPIO_Pin_0);
	GPIO_SetBit(GPIO0,GPIO_Pin_1);
	GPIO_SetBit(GPIO0,GPIO_Pin_2);
  GPIO_SetBit(GPIO0,GPIO_Pin_3);
	GPIO_SetBit(GPIO0,GPIO_Pin_4);
	GPIO_SetBit(GPIO0,GPIO_Pin_5);  		
  GPIO_SetBit(GPIO0,GPIO_Pin_15); 
	
	
  // IN 
	GPIO_InitType.GPIO_Pin = GPIO_Pin_6;
	GPIO_InitType.GPIO_Mode = GPIO_Mode_IN;
	GPIO_InitType.GPIO_Int = GPIO_Int_Disable;

	GPIO_Init(GPIO0,&GPIO_InitType);
 
}


//Initializes UART0
void UartInit(void)
{
  UART_InitTypeDef UART_InitStruct;
	
  UART_InitStruct.UART_Mode.UARTMode_Tx = ENABLE;
  UART_InitStruct.UART_Mode.UARTMode_Rx = ENABLE;
  UART_InitStruct.UART_Int.UARTInt_Tx = DISABLE;
  UART_InitStruct.UART_Int.UARTInt_Rx = DISABLE;
  UART_InitStruct.UART_Ovr.UARTOvr_Tx = DISABLE;
  UART_InitStruct.UART_Ovr.UARTOvr_Rx = DISABLE;
  UART_InitStruct.UART_Hstm = DISABLE;
  UART_InitStruct.UART_BaudRate = Baud_Rate_UART; 
	
  UART_Init(UART0,&UART_InitStruct);
}



//delay
void delay(__IO uint32_t nCount)
{
	for(; nCount != 0; nCount--);
}



uint8_t GPIO_ReadInputDataBit(GPIO_TypeDef* GPIOx, uint16_t GPIO_Pin)
{
  uint8_t bitstatus = 0x00; 
  
  if ((GPIOx->DATA & GPIO_Pin) != 0)
  {
    bitstatus = (uint8_t)1;
  }
  else
  {
    bitstatus = (uint8_t)0;
  }
	
  return bitstatus;
}

void UART_Send_OK (void)
{
	UART_SendChar(UART0,'O');
	UART_SendChar(UART0,'K');
	UART_SendChar(UART0, Simv_CR);
}	


void UART_Send_ERR (void)
{
	UART_SendChar(UART0,'E');
	UART_SendChar(UART0,'R');
	UART_SendChar(UART0,'R');
	UART_SendChar(UART0, Simv_CR);
}	
	
void  UART_Zastavka_UART (void)  
{	
	UART_SendChar(UART0,'T');
	UART_SendChar(UART0,'e');
	UART_SendChar(UART0,'s');
	UART_SendChar(UART0,'t');
	UART_SendChar(UART0,' ');
	UART_SendChar(UART0,'I');
	UART_SendChar(UART0,'P');
	UART_SendChar(UART0,'-');
	UART_SendChar(UART0,'C');
	UART_SendChar(UART0,'o');
	UART_SendChar(UART0,'r');
	UART_SendChar(UART0,'e');
	UART_SendChar(UART0,' ');
	UART_SendChar(UART0,'s');
	UART_SendChar(UART0,'o');
	UART_SendChar(UART0,'f');
	UART_SendChar(UART0,'t');
	UART_SendChar(UART0,' ');
	UART_SendChar(UART0,'K');
	UART_SendChar(UART0,'e');
	UART_SendChar(UART0,'i');
	UART_SendChar(UART0,'l');
	UART_SendChar(UART0, Simv_CR);
}


void  UART_Button_ON (void)
{	
			  UART_SendChar(UART0,'B');	
	      UART_SendChar(UART0,'u');
	      UART_SendChar(UART0,'t');
	      UART_SendChar(UART0,'t');
				UART_SendChar(UART0,'o');
				UART_SendChar(UART0,'n');
				UART_SendChar(UART0,' ');
				UART_SendChar(UART0,'O');
				UART_SendChar(UART0,'N');
				UART_SendChar(UART0, Simv_CR);
}

void  UART_Button_OFF (void)
{	
			  UART_SendChar(UART0,'B');	
	      UART_SendChar(UART0,'u');
	      UART_SendChar(UART0,'t');
	      UART_SendChar(UART0,'t');
				UART_SendChar(UART0,'o');
				UART_SendChar(UART0,'n');
				UART_SendChar(UART0,' ');
				UART_SendChar(UART0,'O');
				UART_SendChar(UART0,'F');
	      UART_SendChar(UART0,'F');
				UART_SendChar(UART0, Simv_CR);
}

