//-------------------------------------------------------------------------------------------------------------------------------------------
//   
//     Проект, реализующий взаимодействие  проекта ПЛИС  (контроллер LCD)   со следующими IP-ядрами: 
//        IP-ядром  MCU  Cortex-M1,  
//        IP-ядром  GPIO, 
//        IP-ядром UART 
//
//     IP-ядро  MCU  управляет выходами светодиодов led_0 - led_5,  подключенными к ПЛИС, 
//     опрашивает  вход  кнопки  button_0, подключенной к ПЛИС 
//     и напрямую взаимодействует с внешним устройством   (ПК)  через UART, выведенный на выоды ПЛИС.           
//     Контроллер  LCD в ПЛИС  выводит  на LCD данные по командам, поступающим из  IP-ядра  MCU 
//     через  IP-ядро  GPIO.      
//  
//     Тактирование проекта ПЛИС от внешнего синхросигнала sys_clk = 27 МГц,  это же и входной сигнал для PLL. 
//     Тактирование IP-ядра  MCU  от выходного синхросигнала PLL  clkout_o_PLL = 54 МГц  
//       
//-------------------------------------------------------------------------------------------------------------------------------------------
module SOFT_Core_MPU
(
    input sys_clk,          // clk input
    input nrst,        // reset input

    inout button_0,       // in button    

    inout led_0,    // out LED pin
    inout led_1,    // out LED pin
    inout led_2,    // out LED pin
    inout led_3,    // out LED pin
    inout led_4,    // out LED pin
    inout led_5,    // out LED pin

    inout Output_upr_ind_LCD,  // 
    
    input Input_upr_ind_LCD,  // 


    output buzzer,         // выход генерации звука

    output [7:0] dat,      // данные ЖКИ  
	output e,              // сигнал e ЖКИ
	output rs,             // сигнал rs ЖКИ
	output rw,             // сигнал rw ЖКИ

    // JTAG    IP-ядра MCU
    inout  TRST_JTAG_Soft,       //  TRST  Soft Cortex-M1
    inout  TDI_JTAG_Soft,        //  TDI  Soft Cortex-M1  
    inout  TMS_JTAG_Soft,        //  TMS  Soft Cortex-M1
    inout  TCLK_JTAG_Soft,       //  TCLK  Soft Cortex-M1
    inout  RTCK_JTAG_Soft,       // RTCK Soft Cortex-M1
    inout  TDO_JTAG_Soft,        //  TDO  Soft Cortex-M1
    
    input  RST_JTAG_Soft,        //  RST  Soft Cortex-M1

  	input UART0RXD_i, //input UART0RXD
    output UART0TXD_o //output UART0TXD

);



//-------------------------------------- -----------------------------------------------------------------------
//  head 
//-------------------------------------------------------------------------------------------------------------
reg led_reg_0 = 1;  // регистр светодиодов
reg led_reg_1 = 1;  // регистр светодиодов
reg led_reg_2 = 1;  // регистр светодиодов
reg led_reg_3 = 1;  // регистр светодиодов
reg led_reg_4 = 1;  // регистр светодиодов
reg led_reg_5 = 1;  // регистр светодиодов 

reg clk_1Hz = 0;  // синхросигнал 1 Гц 
reg clk_05Hz = 0;  // синхросигнал 0,5 Гц
reg clk_1kHz = 0;  // синхросигнал 1 кГц 
reg clk_2kHz = 0;  // синхросигнал 2 кГц
  
reg[31:0] counter_2Hz = 0; //  счетчик  для генерации частоты 2 Гц
reg[31:0] counter_05Hz = 0; //  счетчик  для генерации частоты 0,5 Гц
reg[15:0] counter_2kHz = 0; //  счетчик  для генерации частоты 2000 Гц
reg[15:0] counter_4kHz = 0; //  счетчик  для генерации частоты 4000 Гц

parameter   GLOBAL_CLOCK  = 27_000_000;  // частота глобального синхросигнала, Гц 
parameter  DEL_05Hz = GLOBAL_CLOCK * 2;  // делитель  для получения частоты 0,5 Гц из 27_000_000 Гц
parameter  DEL_1Hz = GLOBAL_CLOCK;  // делитель  для получения частоты 1 Гц из 27_000_000 Гц
parameter  DEL_2Hz = DEL_1Hz / 2;  // делитель  для получения частоты 2 Гц из 27_000_000 Гц
parameter  DEL_2kHz = DEL_1Hz / 1000;  // делитель  для получения частоты 2 кГц из 27_000_000 Гц
parameter  DEL_4kHz = DEL_1Hz / 2000;  // делитель  для получения частоты 4 кГц из 27_000_000 Гц



//-------------------------------------------------------------------------------------------------------------
//  head beep 
//-------------------------------------------------------------------------------------------------------------
reg LCD_zwuk = 0;  // флаг управлени звуком при начальной инициализации ЖКИ
 


//-------------------------------------------------------------------------------------------------------------
//  head LCD
//-------------------------------------------------------------------------------------------------------------
// коды символов для LCD  
parameter  GRAD_C = 'hDF;   // значок градуса Цельсия 
parameter  PUSTOE_ZNAKOMESTO = 'h20;  // пустое знакоместо

reg [15:0] counter_s = 0;  // счетчик для синхронизации   индикации на LCD

reg en = 0; // управление стробом  данных-команд LCD  
reg Init_LCD_start = 0; // флаг разрешения начальной инициализации LCD  
reg Funk_LCD_start = 0; // флаг разрешения текущего функционирования LCD
reg [7:0]  data = 0; // переменная слова данных LCD 
reg rsn = 0; // переменная признака  данные-команды LCD

// регистры данных отображения знакомест LCD 
// строка 1 (16 позиций) 
reg[7:0] REG_LCD_STR1_POZ0 = PUSTOE_ZNAKOMESTO;  
reg[7:0] REG_LCD_STR1_POZ1 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR1_POZ2 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR1_POZ3 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR1_POZ4 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR1_POZ5 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR1_POZ6 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR1_POZ7 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR1_POZ8 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR1_POZ9 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR1_POZ10 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR1_POZ11 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR1_POZ12 = PUSTOE_ZNAKOMESTO; 
reg[7:0] REG_LCD_STR1_POZ13 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR1_POZ14 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR1_POZ15 = PUSTOE_ZNAKOMESTO;

// строка 2 (16 позиций) 
reg[7:0] REG_LCD_STR2_POZ0 = PUSTOE_ZNAKOMESTO;  
reg[7:0] REG_LCD_STR2_POZ1 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR2_POZ2 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR2_POZ3 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR2_POZ4 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR2_POZ5 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR2_POZ6 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR2_POZ7 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR2_POZ8 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR2_POZ9 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR2_POZ10 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR2_POZ11 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR2_POZ12 = PUSTOE_ZNAKOMESTO; 
reg[7:0] REG_LCD_STR2_POZ13 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR2_POZ14 = PUSTOE_ZNAKOMESTO;
reg[7:0] REG_LCD_STR2_POZ15 = PUSTOE_ZNAKOMESTO;


//версия проекта ПЛИС
parameter  ver_H = "1"; // старшая часть  
parameter  ver_L = "0"; // младшая часть 

// начальная заставка на LCD 
// Hello, Friend!
parameter  ZAST_START_0 = "H";
parameter  ZAST_START_1 = "e";
parameter  ZAST_START_2 = "l";
parameter  ZAST_START_3 = "l";
parameter  ZAST_START_4 = "o";
parameter  ZAST_START_5 = ",";
parameter  ZAST_START_6 = " ";
parameter  ZAST_START_7 = "F";
parameter  ZAST_START_8 = "r";
parameter  ZAST_START_9 = "i";
parameter  ZAST_START_10 = "e";
parameter  ZAST_START_11 = "n";
parameter  ZAST_START_12 = "d";
parameter  ZAST_START_13 = "!";
parameter  ZAST_START_14 = "!";
parameter  ZAST_START_15 = "!"; 
 

// Картинка псевдозагрузки псевдо ПО
//  строка 2 
parameter  BOOT_START_0 = "L";
parameter  BOOT_START_1 = "o";
parameter  BOOT_START_2 = "a";
parameter  BOOT_START_3 = "d";
parameter  BOOT_START_4 = ".";
parameter  BOOT_START_5 = ".";
parameter  BOOT_START_6 = ".";
parameter  BOOT_START_7 = ".";
parameter  BOOT_START_8 = ".";
parameter  BOOT_START_9 = ".";
parameter  BOOT_START_10 = ".";
parameter  BOOT_START_11 = ".";
parameter  BOOT_START_12 = ".";
parameter  BOOT_START_13 = ".";
parameter  BOOT_START_14 = ".";
parameter  BOOT_START_15 = ".";

// константы задания временных интервалов управления LCD    
parameter   VALUE_1 = 1; // рабочее значение 
parameter   VALUE_2 = 2 * VALUE_1; //
parameter   VALUE_3 = 3 * VALUE_1; //
parameter   VALUE_4 = 4 * VALUE_1; //
parameter   VALUE_5 = 5 * VALUE_1; //
parameter   VALUE_6 = 6 * VALUE_1; //
parameter   VALUE_7 = 7 * VALUE_1; //
parameter   VALUE_8 = 8 * VALUE_1; //
parameter   VALUE_9 = 9 * VALUE_1; //
parameter   VALUE_10 = 10 * VALUE_1; //
parameter   VALUE_11 = 11 * VALUE_1; // 
parameter   VALUE_12 = 12 * VALUE_1; //
parameter   VALUE_13 = 13 * VALUE_1; //
parameter   VALUE_14 = 14 * VALUE_1; //
parameter   VALUE_15 = 15 * VALUE_1; // 
parameter   VALUE_16 = 16 * VALUE_1; //
parameter   VALUE_17 = 17 * VALUE_1; // 
parameter   VALUE_18 = 18 * VALUE_1; //
parameter   VALUE_19 = 19 * VALUE_1; // 
parameter   VALUE_20 = 20 * VALUE_1; // 
parameter   VALUE_21 = 21 * VALUE_1; //
parameter   VALUE_22 = 22 * VALUE_1; // 
parameter   VALUE_23 = 23 * VALUE_1; // 
parameter   VALUE_24 = 24 * VALUE_1; // 
parameter   VALUE_25 = 25 * VALUE_1; // 
parameter   VALUE_26 = 26 * VALUE_1; // 
parameter   VALUE_27 = 27 * VALUE_1; // 
parameter   VALUE_28 = 28 * VALUE_1; //
parameter   VALUE_29 = 29 * VALUE_1; //
parameter   VALUE_30 = 30 * VALUE_1; //
parameter   VALUE_31 = 31 * VALUE_1; //
parameter   VALUE_32 = 32 * VALUE_1; //
parameter   VALUE_33 = 33 * VALUE_1; //
parameter   VALUE_34 = 34 * VALUE_1; //
parameter   VALUE_35 = 35 * VALUE_1; //
parameter   VALUE_36 = 36 * VALUE_1; //
parameter   VALUE_37 = 37 * VALUE_1; //
parameter   VALUE_38 = 38 * VALUE_1; //
parameter   VALUE_39 = 39 * VALUE_1; //
parameter   VALUE_40 = 40 * VALUE_1; //
parameter   VALUE_41 = 41 * VALUE_1; //
parameter   VALUE_42 = 42 * VALUE_1; //
parameter   VALUE_43 = 43 * VALUE_1; //
parameter   VALUE_44 = 44 * VALUE_1; //
parameter   VALUE_45 = 45 * VALUE_1; //
parameter   VALUE_46 = 46 * VALUE_1; //
parameter   VALUE_47 = 47 * VALUE_1; //
parameter   VALUE_48 = 48 * VALUE_1; //
parameter   VALUE_49 = 49 * VALUE_1; //
parameter   VALUE_50 = 50 * VALUE_1; //
parameter   VALUE_51 = 51 * VALUE_1; //
parameter   VALUE_52 = 52 * VALUE_1; //
parameter   VALUE_53 = 53 * VALUE_1; //
parameter   VALUE_54 = 54 * VALUE_1; //
parameter   VALUE_55 = 55 * VALUE_1; //
parameter   VALUE_56 = 56 * VALUE_1; //
parameter   VALUE_57 = 57 * VALUE_1; //
parameter   VALUE_58 = 58 * VALUE_1; //
parameter   VALUE_59 = 59 * VALUE_1; //
parameter   VALUE_60 = 60 * VALUE_1; //
parameter   VALUE_61 = 61 * VALUE_1; //
parameter   VALUE_62 = 62 * VALUE_1; //
parameter   VALUE_63 = 63 * VALUE_1; //
parameter   VALUE_64 = 64 * VALUE_1; //
parameter   VALUE_65 = 65 * VALUE_1; //
parameter   VALUE_66 = 66 * VALUE_1; //
parameter   VALUE_67 = 67 * VALUE_1; //
parameter   VALUE_68 = 68 * VALUE_1; //
parameter   VALUE_69 = 69 * VALUE_1; //
parameter   VALUE_70 = 70 * VALUE_1; //
parameter   VALUE_71 = 71 * VALUE_1; //
parameter   VALUE_72 = 72 * VALUE_1; //
parameter   VALUE_73 = 73 * VALUE_1; //
parameter   VALUE_74 = 74 * VALUE_1; //
parameter   VALUE_75 = 75 * VALUE_1; //
parameter   VALUE_76 = 76 * VALUE_1; //
parameter   VALUE_77 = 77 * VALUE_1; //
parameter   VALUE_78 = 78 * VALUE_1; //
parameter   VALUE_79 = 79 * VALUE_1; //
parameter   VALUE_80 = 80 * VALUE_1; //
parameter   VALUE_81 = 81 * VALUE_1; //
parameter   VALUE_82 = 82 * VALUE_1; //
parameter   VALUE_83 = 83 * VALUE_1; //
parameter   VALUE_84 = 84 * VALUE_1; //
parameter   VALUE_85 = 85 * VALUE_1; //
parameter   VALUE_86 = 86 * VALUE_1; //
parameter   VALUE_87 = 87 * VALUE_1; //
parameter   VALUE_88 = 88 * VALUE_1; //
parameter   VALUE_89 = 89 * VALUE_1; //
parameter   VALUE_90 = 90 * VALUE_1; //
parameter   VALUE_91 = 91 * VALUE_1; //
parameter   VALUE_92 = 92 * VALUE_1; //
parameter   VALUE_93 = 93 * VALUE_1; //
parameter   VALUE_94 = 94 * VALUE_1; //
parameter   VALUE_95 = 95 * VALUE_1; //
parameter   VALUE_96 = 96 * VALUE_1; //
parameter   VALUE_97 = 97 * VALUE_1; //
parameter   VALUE_98 = 98 * VALUE_1; //
parameter   VALUE_99 = 99 * VALUE_1; //
parameter   VALUE_100 = 100 * VALUE_1; //
parameter   VALUE_101 = 101 * VALUE_1; //
parameter   VALUE_102 = 102 * VALUE_1; //

parameter   VALUE_ZIKL = 400 * VALUE_1; //  интервал циклического вывода данных на LCD

parameter   VALUE_START_BOOT = 1200 * VALUE_1; // время индикации начальной заставки
parameter   VALUE_END_BOOT = 2800 * VALUE_1; // время индикации начальной заставки + время псевдозагрузки псевдо ПО 
 

// константы начальной инициализации LCD  
parameter  Init_LCD_2s_8bit_5x7 = 8'b0011_1100; 
parameter  Init_LCD_d_ON_k_OFF  = 8'b0000_1100;
parameter  Init_LCD_d_NS_k_S    = 8'b0000_0110;
parameter  Init_LCD_d_start     = 8'b0000_0001;
parameter  Init_LCD_1_start     = 8'b0000_0010;
parameter  Init_LCD_2_start     = 8'b1100_0000;



//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------
//    Исполняемый код
//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------

// получение  синхросигналов 1 Гц, 1 кГц  из частоты глобального синхросигнала
// для синхронизации LCD и для формирования звуковых сигналов  
always @(posedge  sys_clk)
begin
   //------------------------------------
	if (counter_2Hz == DEL_2Hz)
	  begin
	     counter_2Hz <= 0;
        //led_reg_0 <= ~led_reg_0;	// индикация  секундного ритма светодиодом 
		  clk_1Hz <= ~clk_1Hz;       
	  end
   else
     begin
        counter_2Hz <= counter_2Hz + 1;  	 
	  end
	//------------------------------------- 	
   //------------------------------------
	if (counter_2kHz == DEL_2kHz)
	  begin
	     counter_2kHz <= 0;
        clk_1kHz <= ~clk_1kHz; // заполнение для формирования звуковых пачек 
	  end
   else
     begin
        counter_2kHz <= counter_2kHz + 1;  	 
	  end
	//------------------------------------- 	 
  //------------------------------------
	if (counter_4kHz == DEL_4kHz)
	  begin
	     counter_4kHz <= 0;
        clk_2kHz <= ~clk_2kHz; // заполнение для формирования звуковых пачек 
	  end
   else
     begin
        counter_4kHz <= counter_4kHz + 1;  	 
	  end
	//------------------------------------- 	 

end 



// получение  синхросигналов 0,5 Гц  из частоты глобального синхросигнала
// для синхронизации LCD и для формирования звуковых сигналов  
always @(posedge  sys_clk)
begin
   //------------------------------------
	if (counter_05Hz == DEL_05Hz)
	  begin
	     counter_05Hz <= 0;
   	    clk_05Hz <= ~clk_05Hz;       
	  end
   else
     begin
        counter_05Hz <= counter_05Hz + 1;  	 
	 end
end 


//---------------------------------------------------------------------------------------------------------
// Текущая индикация на LCD, управляемая  из IP-ядра  MCU 
//---------------------------------------------------------------------------------------------------------
always @(posedge clk_1kHz)  	
 begin 
   if (Input_upr_ind_LCD)    
      begin 
        // Things are good
        REG_LCD_STR1_POZ0 <= "T";  
        REG_LCD_STR1_POZ1 <= "h";
        REG_LCD_STR1_POZ2 <= "i";
        REG_LCD_STR1_POZ3 <= "n";
        REG_LCD_STR1_POZ4 <= "g";
        REG_LCD_STR1_POZ5 <= "s";
        REG_LCD_STR1_POZ6 <= " ";
        REG_LCD_STR1_POZ7 <= "a";
        REG_LCD_STR1_POZ8 <= "r";
        REG_LCD_STR1_POZ9 <= "e";
        REG_LCD_STR1_POZ10 <= " ";
        REG_LCD_STR1_POZ11 <= "g";
        REG_LCD_STR1_POZ12 <= "o"; 
        REG_LCD_STR1_POZ13 <= "o";
        REG_LCD_STR1_POZ14 <= "d";
        REG_LCD_STR1_POZ15 <= " "; 
      end
   else 
      begin 
       // Things are bad
        REG_LCD_STR1_POZ0 <= "T";  
        REG_LCD_STR1_POZ1 <= "h";
        REG_LCD_STR1_POZ2 <= "i";
        REG_LCD_STR1_POZ3 <= "n";
        REG_LCD_STR1_POZ4 <= "g";
        REG_LCD_STR1_POZ5 <= "s";
        REG_LCD_STR1_POZ6 <= " ";
        REG_LCD_STR1_POZ7 <= "a";
        REG_LCD_STR1_POZ8 <= "r";
        REG_LCD_STR1_POZ9 <= "e";
        REG_LCD_STR1_POZ10 <= " ";
        REG_LCD_STR1_POZ11 <= "b";
        REG_LCD_STR1_POZ12 <= "a"; 
        REG_LCD_STR1_POZ13 <= "d";
        REG_LCD_STR1_POZ14 <= " ";
        REG_LCD_STR1_POZ15 <= " ";
      end 
end 





//-----------------------------------------------------------------------------------------------
//     Контроллер LCD  LCD1602 
//
// Выводит на индикацию содержимое констант ZAST_START_0 - ZAST_START_13  в строке 1 
// в  качестве начальной заставки однократно в течение кратковременного интервала, 
// длительность которого определяется значением VALUE_NACH_ZAST, 
// затем  постоянно  (в цикле, период которого определяется значением VALUE_ZIKL)  
// содержимое 15 регистров REG_LCD_STR1_POZ0 - REG_LCD_STR1_POZ15 в строке 1  
// и 15 регистров  REG_LCD_STR2_POZ0 - REG_LCD_STR2_POZ15 в строке 2
// Синхронизируется частотой 1 кГц. 
//-----------------------------------------------------------------------------------------------
// начальная  инициализация и  циклический вывод  данных на LCD
always @(posedge clk_2kHz or posedge (!nrst))       // сброс асинхронный
begin 
   if (!nrst)   
       begin 	  	 
	     Init_LCD_start <= 1;  // разрешить начальную  инициализацию LCD 
		  Funk_LCD_start <= 0;  // запретить текущее функционирование LCD 
		  counter_s <= 0;     
       end
 
   else  if (Init_LCD_start == 1) // если  начальная инициализация LCD разрешена
     begin    
      counter_s <= counter_s + 1;
      //  начальная инициализация LCD 
      case(counter_s) 
        VALUE_1:  begin rsn <= 0; data <= Init_LCD_2s_8bit_5x7;  end  
        VALUE_2:  begin en <= 1;  end  // начало импульса en  
        VALUE_3:  begin en <= 0;  end  // конец импульса en

        VALUE_4:  begin rsn <= 0; data <= Init_LCD_d_ON_k_OFF;  end  
        VALUE_5:  begin en <= 1;  end  // начало импульса en
        VALUE_6:  begin en <= 0;  end  // конец импульса en 
 
        VALUE_7:  begin rsn <= 0; data <= Init_LCD_d_NS_k_S;  end  
        VALUE_8:  begin en <= 1;  end  // начало импульса en
        VALUE_9:  begin en <= 0;  end	// конец импульса en  
	  
          // задание начального  положения курсора - начало первой строки
        VALUE_10:  begin rsn <= 0; data <= Init_LCD_d_start;  end
        VALUE_11:  begin en <= 1;  end  // начало импульса en
        VALUE_12:  begin en <= 0;  end	  

		  // вывод начальной заставки  на LCD  
        VALUE_13:  begin rsn <= 1; data <= ZAST_START_0;   end  
        VALUE_14:  begin en <= 1;  end  // начало импульса en
        VALUE_15:  begin en <= 0;  end	 // конец импульса en 	  

        VALUE_16:  begin rsn <= 1; data <= ZAST_START_1;   end  
        VALUE_17:  begin en <= 1;  end  // начало импульса en
        VALUE_18:  begin en <= 0;  end	 // конец импульса en	  
	  
        VALUE_19:  begin rsn <= 1; data <= ZAST_START_2;   end  
        VALUE_20:  begin en <= 1;  end  // начало импульса en
        VALUE_21:  begin en <= 0;  end	 // конец импульса en
		  
        VALUE_22:  begin rsn <= 1; data <= ZAST_START_3;   end  
        VALUE_23:  begin en <= 1;  end  // начало импульса en
        VALUE_24:  begin en <= 0;  end	 // конец импульса en
			 
        VALUE_25:  begin rsn <= 1; data <= ZAST_START_4;   end  
        VALUE_26:  begin en <= 1;  end  // начало импульса en
        VALUE_27:  begin en <= 0;  end	 // конец импульса en
		  
        VALUE_28:  begin rsn <= 1; data <= ZAST_START_5;   end  
        VALUE_29:  begin en <= 1;  end  // начало импульса en
        VALUE_30:  begin en <= 0;  end	 // конец импульса en	
	
        VALUE_31:  begin rsn <= 1; data <= ZAST_START_6;   end  
        VALUE_32:  begin en <= 1;  end  // начало импульса en
        VALUE_33:  begin en <= 0;  end	 // конец импульса en	
		 
        VALUE_34:  begin rsn <= 1; data <= ZAST_START_7;   end  
        VALUE_35:  begin en <= 1;  end  // начало импульса en
        VALUE_36:  begin en <= 0;  end	 // конец импульса en	
	
        VALUE_37:  begin rsn <= 1; data <= ZAST_START_8;   end  
        VALUE_38:  begin en <= 1;  end  // начало импульса en
        VALUE_39:  begin en <= 0;  end	 // конец импульса en	
		  
        VALUE_40:  begin rsn <= 1; data <= ZAST_START_9;   end  
        VALUE_41:  begin en <= 1;  end  // начало импульса en
        VALUE_42:  begin en <= 0;  end	 // конец импульса en	

        VALUE_43:  begin rsn <= 1; data <= ZAST_START_10;   end  
        VALUE_44:  begin en <= 1;  end  // начало импульса en
        VALUE_45:  begin en <= 0;  end	 // конец импульса en			  
		  	  
        VALUE_46:  begin rsn <= 1; data <= ZAST_START_11;   end  
        VALUE_47:  begin en <= 1;  end  // начало импульса en
        VALUE_48:  begin en <= 0;  end	 // конец импульса en			  

        VALUE_49:  begin rsn <= 1; data <= ZAST_START_12;   end  
        VALUE_50:  begin en <= 1;  end  // начало импульса en
        VALUE_51:  begin en <= 0;  end	 // конец импульса en			  
						 
        VALUE_52:  begin rsn <= 1; data <= ZAST_START_13;   end  
        VALUE_53:  begin en <= 1;  end  // начало импульса en
        VALUE_54:  begin en <= 0;  end	 // конец импульса en								 
									 
        VALUE_55:  begin rsn <= 1; data <= ZAST_START_14;   end  
        VALUE_56:  begin en <= 1;  end  // начало импульса en
        VALUE_57:  begin en <= 0;  end	 // конец импульса en	

        VALUE_58:  begin rsn <= 1; data <= ZAST_START_15;   end  
        VALUE_59:  begin en <= 1;  end  // начало импульса en
        VALUE_60:  begin en <= 0;  end	 // конец импульса en	

   	       // повторное задание начального  положения курсора - начало второй строки
        VALUE_61:  begin rsn <= 0; data <= Init_LCD_2_start;   end  
        VALUE_62:  begin en <= 1;  end  // начало импульса en
        VALUE_63:  begin en <= 0;  end	 // конец импульса en			
		  // Идет индикация начальной заставки  на LCD 
		 
		  // Начало индикации псевдозагрузки псевдо ПО
		VALUE_START_BOOT + 1:  begin rsn <= 1; data <= BOOT_START_0;  end 
        VALUE_START_BOOT + 2:  begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 3:  begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 40: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 80: begin LCD_zwuk <= 0;  end // выключить звук 
		  
        VALUE_START_BOOT + 81: begin rsn <= 1; data <= BOOT_START_1;  end 
        VALUE_START_BOOT + 82: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 83: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 120: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 160: begin LCD_zwuk <= 0;  end // выключить звук 
		  
        VALUE_START_BOOT + 161: begin rsn <= 1; data <= BOOT_START_2;  end 
        VALUE_START_BOOT + 162: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 163: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 200: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 240: begin LCD_zwuk <= 0;  end // выключить звук 
		  
        VALUE_START_BOOT + 241: begin rsn <= 1; data <= BOOT_START_3;  end 
        VALUE_START_BOOT + 242: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 243: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 280: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 320: begin LCD_zwuk <= 0;  end // выключить звук 

        VALUE_START_BOOT + 321: begin rsn <= 1; data <= BOOT_START_4;  end 
        VALUE_START_BOOT + 322: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 323: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 360: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 400: begin LCD_zwuk <= 0;  end // выключить звук 

        VALUE_START_BOOT + 401: begin rsn <= 1; data <= BOOT_START_5;  end 
        VALUE_START_BOOT + 402: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 403: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 440: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 480: begin LCD_zwuk <= 0;  end // выключить звук 

        VALUE_START_BOOT + 481: begin rsn <= 1; data <= BOOT_START_6;  end 
        VALUE_START_BOOT + 482: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 483: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 520: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 560: begin LCD_zwuk <= 0;  end // выключить звук 

        VALUE_START_BOOT + 561: begin rsn <= 1; data <= BOOT_START_7;  end 
        VALUE_START_BOOT + 562: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 563: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 600: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 640: begin LCD_zwuk <= 0;  end // выключить звук 

        VALUE_START_BOOT + 641: begin rsn <= 1; data <= BOOT_START_8;  end 
        VALUE_START_BOOT + 642: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 643: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 680: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 720: begin LCD_zwuk <= 0;  end // выключить звук 

        VALUE_START_BOOT + 721: begin rsn <= 1; data <= BOOT_START_9;  end 
        VALUE_START_BOOT + 722: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 723: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 760: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 800: begin LCD_zwuk <= 0;  end // выключить звук 

        VALUE_START_BOOT + 801: begin rsn <= 1; data <= BOOT_START_10;  end 
        VALUE_START_BOOT + 802: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 803: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 840: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 880: begin LCD_zwuk <= 0;  end // выключить звук

        VALUE_START_BOOT + 881: begin rsn <= 1; data <= BOOT_START_11;  end 
        VALUE_START_BOOT + 882: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 883: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 920: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 960: begin LCD_zwuk <= 0;  end // выключить звук

        VALUE_START_BOOT + 961: begin rsn <= 1; data <= BOOT_START_12;  end 
        VALUE_START_BOOT + 962: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 963: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 1000: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 1040: begin LCD_zwuk <= 0;  end // выключить звук

        VALUE_START_BOOT + 1041: begin rsn <= 1; data <= BOOT_START_13;  end 
        VALUE_START_BOOT + 1042: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 1043: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 1080: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 1120: begin LCD_zwuk <= 0;  end // выключить звук

        VALUE_START_BOOT + 1121: begin rsn <= 1; data <= BOOT_START_14;  end 
        VALUE_START_BOOT + 1122: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 1123: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 1160: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 1200: begin LCD_zwuk <= 0;  end // выключить звук

        VALUE_START_BOOT + 1201: begin rsn <= 1; data <= BOOT_START_15;  end 
        VALUE_START_BOOT + 1202: begin en <= 1;  end  // начало импульса en
        VALUE_START_BOOT + 1203: begin en <= 0;  end	 // конец импульса en
		  
		VALUE_START_BOOT + 1240: begin LCD_zwuk <= 1;  end // выключить звук 
		VALUE_START_BOOT + 1280: begin LCD_zwuk <= 0;  end // выключить звук

		  				
        VALUE_END_BOOT:    // метка времени окончания индикации псевдозагрузки псевдо ПО
          begin 
		 	  counter_s <= 0; 
			  Init_LCD_start <= 0;  // запретить начальную  инициализацию LCD
			  Funk_LCD_start <= 1;  // разрешить текущее функционирование LCD  
	       end 	  
       endcase
	    //--------------------------------------------
  end
       
  else if (Funk_LCD_start == 1) // если текущее функционирование LCD разрешено
     begin    
       counter_s <= counter_s + 1;
       //   текущее функционирование LCD - вывод  данных на индикацию 
       case(counter_s) 
		 // задание начального  положения курсора - начало первой строки 
       VALUE_1:  begin rsn <= 0; data <= Init_LCD_1_start;  end  
       VALUE_2:  begin en <= 1;  end  // начало импульса en
       VALUE_3:  begin en <= 0;  end	  
	  
	    // символ 0 
       VALUE_4:  begin rsn <= 1; data <= REG_LCD_STR1_POZ0; end
       VALUE_5:  begin en <= 1;  end  // начало импульса en
       VALUE_6:  begin en <= 0;  end	 // конец импульса en 

		 // символ 1  
       VALUE_7:  begin rsn <= 1; data <= REG_LCD_STR1_POZ1; end 
       VALUE_8:  begin en <= 1;  end  // начало импульса en
       VALUE_9:  begin en <= 0;  end	 // конец импульса en 		 
	  	 
		 // символ 2 
       VALUE_10:  begin rsn <= 1; data <= REG_LCD_STR1_POZ2; end  				 
       VALUE_11:  begin en <= 1;  end  // начало импульса en
       VALUE_12:  begin en <= 0;  end	 // конец импульса en 	  

		 // символ 3 
       VALUE_13:  begin rsn <= 1; data <= REG_LCD_STR1_POZ3; end
       VALUE_14:  begin en <= 1;  end  // начало импульса en
       VALUE_15:  begin en <= 0;  end	 // конец импульса en	  
	  
	    // символ 4
       VALUE_16:  begin rsn <= 1; data <= REG_LCD_STR1_POZ4; end
       VALUE_17:  begin en <= 1;  end  // начало импульса en
       VALUE_18:  begin en <= 0;  end	 // конец импульса en	
		 
		 // символ 5
       VALUE_19:  begin rsn <= 1; data <= REG_LCD_STR1_POZ5; end  		 
       VALUE_20:  begin en <= 1;  end  // начало импульса en
       VALUE_21:  begin en <= 0;  end	 // конец импульса en	
		 
		 // символ 6
       VALUE_22:  begin rsn <= 1; data <= REG_LCD_STR1_POZ6; end
       VALUE_23:  begin en <= 1;  end  // начало импульса en
       VALUE_24:  begin en <= 0;  end	 // конец импульса en	

		 // символ 7 
       VALUE_25:  begin rsn <= 1; data <= REG_LCD_STR1_POZ7; end
       VALUE_26:  begin en <= 1;  end  // начало импульса en
       VALUE_27:  begin en <= 0;  end	 // конец импульса en

		 // символ 8
       VALUE_28:  begin rsn <= 1; data <= REG_LCD_STR1_POZ8; end 
		 VALUE_29:  begin en <= 1;  end  // начало импульса en
       VALUE_30:  begin en <= 0;  end	 // конец импульса en		 
			
		 // символ 9	
       VALUE_31:  begin rsn <= 1; data <= REG_LCD_STR1_POZ9; end 						
       VALUE_32:  begin en <= 1;  end  // начало импульса en
       VALUE_33:  begin en <= 0;  end	 // конец импульса en	

		 // символ 10
       VALUE_34:  begin rsn <= 1; data <= REG_LCD_STR1_POZ10; end 								
       VALUE_35:  begin en <= 1;  end  // начало импульса en
       VALUE_36:  begin en <= 0;  end	 // конец импульса en	

		 // символ 11
       VALUE_37:  begin rsn <= 1; data <= REG_LCD_STR1_POZ11; end  
       VALUE_38:  begin en <= 1;  end  // начало импульса en
       VALUE_39:  begin en <= 0;  end	 // конец импульса en	

		 // символ 12 
       VALUE_40:  begin rsn <= 1; data <= REG_LCD_STR1_POZ12; end 						 
       VALUE_41:  begin en <= 1;  end  // начало импульса en
       VALUE_42:  begin en <= 0;  end	 // конец импульса en	

		 // символ 13
       VALUE_43:  begin rsn <= 1; data <= REG_LCD_STR1_POZ13; end 			 
       VALUE_44:  begin en <= 1;  end  // начало импульса en
       VALUE_45:  begin en <= 0;  end	 // конец импульса en		
				
		 // символ 14		
       VALUE_46:  begin rsn <= 1; data <= REG_LCD_STR1_POZ14; end 						 
       VALUE_47:  begin en <= 1;  end  // начало импульса en
       VALUE_48:  begin en <= 0;  end	 // конец импульса en	

		 // символ 15
       VALUE_49:  begin rsn <= 1; data <= REG_LCD_STR1_POZ15; end
       VALUE_50:  begin en <= 1;  end  // начало импульса en
       VALUE_51:  begin en <= 0;  end	 // конец импульса en						
						
		 // задание начального  положения курсора - начало второй строки 
       VALUE_52:  begin rsn <= 0; data <= Init_LCD_2_start;  end  
       VALUE_53:  begin en <= 1;  end  // начало импульса en
       VALUE_54:  begin en <= 0;  end	
		 
		 // символ 16
       VALUE_55:  begin rsn <= 1; data <= REG_LCD_STR2_POZ0;   end 
       VALUE_56:  begin en <= 1;  end  // начало импульса en
       VALUE_57:  begin en <= 0;  end	 // конец импульса en 		 
		 
		 // символ 17
       VALUE_58:  begin rsn <= 1; data <= REG_LCD_STR2_POZ1;   end 
       VALUE_59:  begin en <= 1;  end  // начало импульса en
       VALUE_60:  begin en <= 0;  end	 // конец импульса en 		 
	  	  
		 // символ 18 
       VALUE_61:  begin rsn <= 1; data <= REG_LCD_STR2_POZ2; end  				 
       VALUE_62:  begin en <= 1;  end  // начало импульса en
       VALUE_63:  begin en <= 0;  end	 // конец импульса en 	  

		 // символ 19
       VALUE_64:  begin rsn <= 1; data <= REG_LCD_STR2_POZ3;   end  		
       VALUE_65:  begin en <= 1;  end  // начало импульса en
       VALUE_66:  begin en <= 0;  end	 // конец импульса en	  
	  
	    // символ 20
       VALUE_67:  begin rsn <= 1; data <= REG_LCD_STR2_POZ4;   end  
       VALUE_68:  begin en <= 1;  end  // начало импульса en
       VALUE_69:  begin en <= 0;  end	 // конец импульса en	
		 
		 // символ 21
       VALUE_70:  begin rsn <= 1; data <= REG_LCD_STR2_POZ5; end  		 
       VALUE_71:  begin en <= 1;  end  // начало импульса en
       VALUE_72:  begin en <= 0;  end	 // конец импульса en	
		 
		 // символ 22
       VALUE_73:  begin rsn <= 1; data <= REG_LCD_STR2_POZ6;   end	 
       VALUE_74:  begin en <= 1;  end  // начало импульса en
       VALUE_75:  begin en <= 0;  end	 // конец импульса en	

		 // символ 23
       VALUE_76:  begin rsn <= 1; data <= REG_LCD_STR2_POZ7;   end    
       VALUE_77:  begin en <= 1;  end  // начало импульса en
       VALUE_78:  begin en <= 0;  end	 // конец импульса en

		 // символ 24
       VALUE_79:  begin rsn <= 1; data <= REG_LCD_STR2_POZ8;  end  
		 VALUE_80:  begin en <= 1;  end  // начало импульса en
       VALUE_81:  begin en <= 0;  end	 // конец импульса en		 
		
	    // символ 25	
       VALUE_82:  begin rsn <= 1; data <= REG_LCD_STR2_POZ9;   end					
       VALUE_83:  begin en <= 1;  end  // начало импульса en
       VALUE_84:  begin en <= 0;  end	 // конец импульса en	

		 // символ 26
       VALUE_85:  begin rsn <= 1; data <= REG_LCD_STR2_POZ10; end 								
       VALUE_86:  begin en <= 1;  end  // начало импульса en
       VALUE_87:  begin en <= 0;  end	 // конец импульса en	

		 // символ 27 
       VALUE_88:  begin rsn <= 1; data <= REG_LCD_STR2_POZ11;  end  		 
       VALUE_89:  begin en <= 1;  end  // начало импульса en
       VALUE_90:  begin en <= 0;  end	 // конец импульса en	

		 // символ 28
       VALUE_91:  begin rsn <= 1; data <= REG_LCD_STR2_POZ12;  end  	 						 
       VALUE_92:  begin en <= 1;  end  // начало импульса en
       VALUE_93:  begin en <= 0;  end	 // конец импульса en	

		 // символ 29
       VALUE_94:  begin rsn <= 1; data <= REG_LCD_STR2_POZ13; end 			 
       VALUE_95:  begin en <= 1;  end  // начало импульса en
       VALUE_96:  begin en <= 0;  end	 // конец импульса en	

       // символ 30		 
       VALUE_97:  begin rsn <= 1; data <= REG_LCD_STR2_POZ14;  end  	
       VALUE_98:  begin en <= 1;  end  // начало импульса en
       VALUE_99:  begin en <= 0;  end	 // конец импульса en	  
 
       // символ 31
       VALUE_100: begin rsn <= 1; data <= REG_LCD_STR2_POZ15;  end   
       VALUE_101: begin en <= 1;  end  // начало импульса en
       VALUE_102: begin en <= 0;  end	 // конец импульса en 
								
       VALUE_ZIKL: begin counter_s <= 0; end 	  
       endcase
	   //---------------------------------------------------------------------------
  end
end 







// Формирование сигналов LCD  
//------------------------------------------------------------ 
assign dat = data; 
assign rs = rsn;  
 
assign e = en; 
assign rw = 0;
//-----------------------------------------------------------

// Назначение,  какие источники управляют выходом звука
assign buzzer = (clk_1kHz & LCD_zwuk); 


//-----------------------------------------------------------------------------------------------------------------------
// IP-ядро PLL 
//-----------------------------------------------------------------------------------------------------------------------
   
wire clkout_o_PLL;  // выходной синхросигнал PLL

Gowin_rPLL Gowin_rPLL_1(
        .clkout(clkout_o_PLL), //output clkout PLL
        .clkin(sys_clk) //input clkin
    );



//-----------------------------------------------------------------------------------------------------------------------
// IP-ядро MPU и его обслуживание 
//-----------------------------------------------------------------------------------------------------------------------

wire  GND_Wire;  //  цепь  общего провода 

wire[15:0] GPIO_io; //   цепи входов/выходов GPIO 

assign GND_Wire = 0;  //  управление цепью общего провода 



// управление светодиодами из IP-ядра 
assign led_0 = GPIO_io[0]; // управление светодиодом от GPIO  IP-ядра  MCU
assign led_1 = GPIO_io[1]; // управление светодиодом от GPIO  IP-ядра  MCU 
assign led_2 = GPIO_io[2]; // управление светодиодом от GPIO  IP-ядра  MCU
assign led_3 = GPIO_io[3]; // управление светодиодом от GPIO  IP-ядра  MCU
assign led_4 = GPIO_io[4]; // управление светодиодом от GPIO  IP-ядра  MCU
assign led_5 = GPIO_io[5]; // управление светодиодом от GPIO  IP-ядра  MCU


 // чтение состояния кнопки в IP-ядро MCU 
assign  GPIO_io[6] = button_0;

// управление выходом управления индикации LCD  из IP-ядра MCU   
assign  Output_upr_ind_LCD = GPIO_io[15]; // управление цепью управления индикации LCD  



// UART0  в  проекте ПЛИС  не обслуживается, его линии с входов/выходов ПЛИС транзитом идут в IP-ядро MPU 



// Модуль  IP-ядра  Cortex-M1 с IP-ядрами   UART0  и GPIO
// GPIO - двунаправленные линии 
	Gowin_EMPU_M1_Top Gowin_EMPU_M1_Top_1
    (
		.LOCKUP(LOCKUP_o), //output LOCKUP
		.HALTED(HALTED_o), //output HALTED
	
        .GPIO(GPIO_io), //inout [15:0] GPIO
	    		
        .JTAG_3(TRST_JTAG_Soft), //inout JTAG_3
		.JTAG_4(GND_Wire), //inout JTAG_4
		.JTAG_5(TDI_JTAG_Soft), //inout JTAG_5
		.JTAG_6(GND_Wire), //inout JTAG_6
		.JTAG_7(TMS_JTAG_Soft), //inout JTAG_7
		.JTAG_8(GND_Wire), //inout JTAG_8
		.JTAG_9(TCLK_JTAG_Soft), //inout JTAG_9
		.JTAG_10(GND_Wire), //inout JTAG_10
		.JTAG_11(RTCK_JTAG_Soft), //inout JTAG_11
		.JTAG_12(GND_Wire), //inout JTAG_12
		.JTAG_13(TDO_JTAG_Soft), //inout JTAG_13
		.JTAG_14(GND_Wire), //inout JTAG_14
		.JTAG_15(RST_JTAG_Soft), //inout JTAG_15
		.JTAG_16(GND_Wire), //inout JTAG_16
		.JTAG_17(GND_Wire), //inout JTAG_17
		.JTAG_18(GND_Wire), //inout JTAG_18

        .UART0RXD(UART0RXD_i), //input UART0RXD
		.UART0TXD(UART0TXD_o), //output UART0TXD

		.HCLK(clkout_o_PLL), //input HCLK
		.hwRstn(nrst) //input hwRstn
	);

  


endmodule